/*
 * ParameterDialog.java
 *
 * Created on 29. März 2004, 14:24
 */

package ch.hslu.cm.oo;

import java.awt.*;
import javax.swing.*;
/**
 *
 * @author  wrandels
 */
public class ParameterDialog extends javax.swing.JDialog {
    private boolean accepted;
    
    /** Creates new form ParameterDialog */
    public ParameterDialog(Frame parent) {
        super(parent, true);
        initComponents();
    }
    public ParameterDialog(Dialog parent) {
        super(parent, true);
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        parameterPanel = new javax.swing.JPanel();
        buttonsPanel = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        okayButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        operationNameLabel = new javax.swing.JLabel();

        FormListener formListener = new FormListener();

        setTitle("Operation ausf\u00fchren");
        setResizable(false);
        addWindowListener(formListener);

        parameterPanel.setLayout(new java.awt.GridBagLayout());

        parameterPanel.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(20, 20, 0, 20)));
        getContentPane().add(parameterPanel, java.awt.BorderLayout.CENTER);

        buttonsPanel.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.CENTER, 0, 0));

        buttonsPanel.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(20, 20, 20, 20)));
        jPanel1.setLayout(new java.awt.GridLayout(1, 2, 10, 0));

        okayButton.setText("OK");
        okayButton.addActionListener(formListener);

        jPanel1.add(okayButton);

        cancelButton.setText("Abbrechen");
        cancelButton.addActionListener(formListener);

        jPanel1.add(cancelButton);

        buttonsPanel.add(jPanel1);

        getContentPane().add(buttonsPanel, java.awt.BorderLayout.SOUTH);

        jPanel2.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT, 0, 0));

        jPanel2.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(20, 20, 0, 20)));
        jPanel2.add(operationNameLabel);

        getContentPane().add(jPanel2, java.awt.BorderLayout.NORTH);

        pack();
    }

    // Code for dispatching events from components to event handlers.

    private class FormListener implements java.awt.event.ActionListener, java.awt.event.WindowListener {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            if (evt.getSource() == okayButton) {
                ParameterDialog.this.okay(evt);
            }
            else if (evt.getSource() == cancelButton) {
                ParameterDialog.this.cancel(evt);
            }
        }

        public void windowActivated(java.awt.event.WindowEvent evt) {
        }

        public void windowClosed(java.awt.event.WindowEvent evt) {
        }

        public void windowClosing(java.awt.event.WindowEvent evt) {
            if (evt.getSource() == ParameterDialog.this) {
                ParameterDialog.this.closeDialog(evt);
            }
        }

        public void windowDeactivated(java.awt.event.WindowEvent evt) {
        }

        public void windowDeiconified(java.awt.event.WindowEvent evt) {
        }

        public void windowIconified(java.awt.event.WindowEvent evt) {
        }

        public void windowOpened(java.awt.event.WindowEvent evt) {
        }
    }//GEN-END:initComponents
    
    private void cancel(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancel
        accepted = false;
        setVisible(false);
        dispose();
    }//GEN-LAST:event_cancel
    
    private void okay(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okay
        accepted = true;
        setVisible(false);
        dispose();
    }//GEN-LAST:event_okay
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        accepted = false;
        setVisible(false);
        dispose();
    }//GEN-LAST:event_closeDialog
    
    public static String[] show(Component parentComponent, String operationName, String[] parameterNames) {
        Window window = getWindowForComponent(parentComponent);
        ParameterDialog dialog;
        if (window instanceof Frame) {
            dialog = new ParameterDialog((Frame)window);
        } else {
            dialog = new ParameterDialog((Dialog)window);
        }
        dialog.operationNameLabel.setText(operationName);
        
        JTextField[] textFields = new JTextField[parameterNames.length];
        for (int i=0; i < parameterNames.length; i++) {
            GridBagConstraints c;
            JLabel label = new JLabel(parameterNames[i]+":");
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = i;
            c.insets = new Insets(2, 0, 0, 0);
            c.anchor = GridBagConstraints.NORTHWEST;
            dialog.parameterPanel.add(label, c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = i;
            c.insets = new Insets(2, 12, 0, 0);
            c.anchor = GridBagConstraints.NORTHWEST;
            if (i == parameterNames.length - 1) {
                c.weightx = 1.0;
                c.weighty = 1.0;
            }
            textFields[i] = new JTextField(20);
            dialog.parameterPanel.add(textFields[i], c);
        }
        dialog.pack();
        dialog.setLocationRelativeTo(parentComponent);
        dialog.show();
        if (dialog.accepted) {
            String[] values = new String[textFields.length];
            for (int i=0; i < textFields.length; i++) {
                values[i] = textFields[i].getText();
            }
            return values;
        } else {
            return null;
        }
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new ParameterDialog(new javax.swing.JFrame()).show();
    }
    
    static Window getWindowForComponent(Component parentComponent)
    throws HeadlessException {
        if (parentComponent == null)
            return JOptionPane.getRootFrame();
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog)
            return (Window)parentComponent;
        return getWindowForComponent(parentComponent.getParent());
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel buttonsPanel;
    private javax.swing.JButton cancelButton;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JButton okayButton;
    private javax.swing.JLabel operationNameLabel;
    private javax.swing.JPanel parameterPanel;
    // End of variables declaration//GEN-END:variables
    
}
